<?php
include "../config/database.php";
include "cek_login.php";

require '../vendor/autoload.php';

use Mpdf\Mpdf;

$id       = $_GET['id'] ?? null;
$semester = $_GET['semester'] ?? 1;

if(!$id){
    die("ID siswa tidak ditemukan");
}

// DATA SISWA
$siswa = mysqli_fetch_assoc(
    mysqli_query($conn,"SELECT * FROM siswa WHERE id='$id'")
);

// DATA NILAI + MAPEL
$q = mysqli_query($conn,"
    SELECT m.nama AS mapel, n.nilai
    FROM nilai_raport n
    JOIN mapel m ON n.mapel = m.kode
    WHERE n.siswa_id='$id'
    AND n.semester='$semester'
    ORDER BY m.id ASC
");

// REKAP
$rekap = mysqli_fetch_assoc(
    mysqli_query($conn,"
        SELECT 
            COUNT(*) AS jml,
            SUM(nilai) AS total,
            ROUND(AVG(nilai),2) AS rata
        FROM nilai_raport
        WHERE siswa_id='$id'
        AND semester='$semester'
    ")
);

$mpdf = new Mpdf([
    'format' => 'A4',
    'margin_top' => 15,
    'margin_bottom' => 15
]);

$html = '
<style>
body{font-family:Arial;font-size:11pt}
table{border-collapse:collapse;width:100%}
th,td{border:1px solid #000;padding:6px}
th{background:#f0f0f0}
.title{text-align:center;font-size:14pt;font-weight:bold}
.sub{text-align:center;margin-bottom:10px}
</style>

<div class="title">MAN 1 Kota Lubuklinggau</div>
<div class="sub">Verifikasi Nilai - Semester '.$semester.'</div>

<table style="margin-bottom:10px">
<tr>
    <td width="20%">Nama</td>
    <td width="30%">'.$siswa['nama'].'</td>
    
</tr>
<tr>
    <td>NISN</td>
    <td>'.$siswa['nisn'].'</td>
    
</tr>
<tr>
    <td width="20%">Kelas</td>
    <td width="30%">'.$siswa['kelas'].'</td>
    
</tr>
</table>

<table>
<tr>
    <th width="5%">No</th>
    <th>Mata Pelajaran</th>
    <th width="20%">Nilai</th>
</tr>';

$no=1;
while($d=mysqli_fetch_assoc($q)){
    $html .= '
    <tr>
        <td align="center">'.$no++.'</td>
        <td>'.$d['mapel'].'</td>
        <td align="center">'.$d['nilai'].'</td>
    </tr>';
}

$html .= '
</table>

<br>

<table>
<tr>
    <th width="33%">Jumlah Mapel</th>
    <th width="33%">Total Nilai</th>
    <th width="34%">Rata-rata</th>
</tr>
<tr>
    <td align="center">'.$rekap['jml'].'</td>
    <td align="center">'.$rekap['total'].'</td>
    <td align="center">'.$rekap['rata'].'</td>
</tr>
</table>

<br><br>

<table width="100%" style="border:none">

</table>
';

$mpdf->WriteHTML($html);
$mpdf->Output("Nilai_{$siswa['nama']}_Semester_{$semester}.pdf","I");
