<?php
include "../config/database.php";
include "cek_login.php";

header("Content-Type: text/csv; charset=utf-8");
header("Content-Disposition: attachment; filename=rekap_verifikasi_siswa.csv");

$output = fopen("php://output", "w");

// Header kolom
fputcsv($output, [
    'NISN',
    'Nama',
    'Kelas',
    'Status Verifikasi',
    'Waktu Verifikasi'
]);

$q = mysqli_query($conn, "
    SELECT 
        s.nisn,
        s.nama,
        s.kelas,
        IFNULL(v.status,'BELUM') AS status,
        v.waktu_verifikasi
    FROM siswa s
    LEFT JOIN verifikasi_nilai v ON s.id = v.siswa_id
    ORDER BY s.kelas ASC, s.nama ASC
");

while ($d = mysqli_fetch_assoc($q)) {
    fputcsv($output, [
        $d['nisn'],
        $d['nama'],
        $d['kelas'],
        $d['status'],
        $d['waktu_verifikasi']
    ]);
}

fclose($output);
exit;
