<?php
include "../config/database.php";
include "cek_login.php";

require '../vendor/autoload.php';
use Mpdf\Mpdf;

$id = $_GET['id'] ?? null;
if(!$id){
    die("ID siswa tidak ditemukan");
}

// DATA SISWA
$siswa = mysqli_fetch_assoc(
    mysqli_query($conn,"SELECT * FROM siswa WHERE id='$id'")
);

$mpdf = new Mpdf([
    'format' => 'A4',
    'margin_top' => 15,
    'margin_bottom' => 15
]);

$html = '
<style>
body{font-family:Arial;font-size:11pt}
table{border-collapse:collapse;width:100%}
th,td{border:1px solid #000;padding:6px}
th{background:#f0f0f0}
.title{text-align:center;font-size:14pt;font-weight:bold}
.sub{text-align:center;margin-bottom:10px}
.semester{margin-top:15px;font-weight:bold}
</style>

<div class="title">MAN 1 Kota Lubuklinggau</div>
<div class="sub">Rekap Nilai Semester 1 s.d 5</div>

<table style="margin-bottom:10px">
<tr><td width="20%">Nama</td><td>'.$siswa['nama'].'</td></tr>
<tr><td>NISN</td><td>'.$siswa['nisn'].'</td></tr>
<tr><td>Kelas</td><td>'.$siswa['kelas'].'</td></tr>
</table>
';

// LOOP SEMESTER 1–5
for($semester=1; $semester<=5; $semester++){

    $q = mysqli_query($conn,"
        SELECT m.nama AS mapel, n.nilai
        FROM nilai_raport n
        JOIN mapel m ON n.mapel = m.kode
        WHERE n.siswa_id='$id'
        AND n.semester='$semester'
        ORDER BY m.id ASC
    ");

    if(mysqli_num_rows($q)==0) continue;

    // PAGE BARU KECUALI SEMESTER PERTAMA
    if($semester > 1){
        $html .= '<pagebreak />';
    }

    $rekap = mysqli_fetch_assoc(
        mysqli_query($conn,"
            SELECT 
                COUNT(*) AS jml,
                SUM(nilai) AS total,
                ROUND(AVG(nilai),2) AS rata
            FROM nilai_raport
            WHERE siswa_id='$id'
            AND semester='$semester'
        ")
    );

    $html .= '
    <div class="title">MAN 1 Kota Lubuklinggau</div>
    <div class="sub">Laporan Hasil Belajar</div>

    <table style="margin-bottom:10px">
        <tr><td width="20%">Nama</td><td>'.$siswa['nama'].'</td></tr>
        <tr><td>NISN</td><td>'.$siswa['nisn'].'</td></tr>
        <tr><td>Kelas</td><td>'.$siswa['kelas'].'</td></tr>
        <tr><td>Semester</td><td>'.$semester.'</td></tr>
    </table>

    <table>
        <tr>
            <th width="5%">No</th>
            <th>Mata Pelajaran</th>
            <th width="20%">Nilai</th>
        </tr>';

    $no=1;
    while($d=mysqli_fetch_assoc($q)){
        $html .= '
        <tr>
            <td align="center">'.$no++.'</td>
            <td>'.$d['mapel'].'</td>
            <td align="center">'.$d['nilai'].'</td>
        </tr>';
    }

    $html .= '
    </table>

    <table style="margin-top:5px">
        <tr>
            <th width="33%">Jumlah Mapel</th>
            <th width="33%">Total Nilai</th>
            <th width="34%">Rata-rata</th>
        </tr>
        <tr>
            <td align="center">'.$rekap['jml'].'</td>
            <td align="center">'.$rekap['total'].'</td>
            <td align="center">'.$rekap['rata'].'</td>
        </tr>
    </table>';
}


$mpdf->WriteHTML($html);
$mpdf->Output("Nilai_{$siswa['nama']}_Semester_1-5.pdf","I");
